﻿//////////////////////////////////////////////
// CameraWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkGraphicsWrap
{
	class DLL_ASTRAEUS_EXPORT CameraWrapper final
	{
		public :

			// Environment update
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks
			// Getters
			static nkScripts::OutputValue getNear (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getFar (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getFrustum (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getPerspectiveFov (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getOrthographicHeight (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getDirectionAtPixelView (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getDirectionAtPixelWorld (const nkScripts::DataStack& stack) ;
	} ;
}